/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.AgentAction;
import jade.content.ContentElementList;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.lang.sl.SL0Vocabulary;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.UnknownSchemaException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Done;
import jade.content.onto.basic.Equals;
import jade.content.onto.basic.FalseProposition;
import jade.content.onto.basic.Result;
import jade.content.onto.basic.TrueProposition;
import jade.content.schema.AgentActionSchema;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ConceptSchema;
import jade.content.schema.ContentElementListSchema;
import jade.content.schema.ObjectSchema;
import jade.content.schema.PredicateSchema;
import jade.content.schema.PrimitiveSchema;
import jade.content.schema.TermSchema;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class BasicOntology
extends Ontology
implements SL0Vocabulary {
    private static final BasicOntology theInstance = new BasicOntology();
    public static final String STRING = "BO_String";
    public static final String FLOAT = "BO_Float";
    public static final String INTEGER = "BO_Integer";
    public static final String BOOLEAN = "BO_Boolean";
    public static final String DATE = "BO_Date";
    public static final String BYTE_SEQUENCE = "BO_Byte-sequence";
    public static final String CONTENT_ELEMENT_LIST = "ContentElementList";

    private BasicOntology() {
        super("BASIC_ONTOLOGY", (Ontology)null, null);
    }

    private void initialize() {
        try {
            this.add(new PrimitiveSchema(STRING));
            this.add(new PrimitiveSchema(FLOAT));
            this.add(new PrimitiveSchema(INTEGER));
            this.add(new PrimitiveSchema(BOOLEAN));
            this.add(new PrimitiveSchema(DATE));
            this.add(new PrimitiveSchema(BYTE_SEQUENCE));
            this.add(new AggregateSchema("sequence"));
            this.add(new AggregateSchema("set"));
            this.add(ContentElementListSchema.getBaseSchema());
            ConceptSchema aidSchema = new ConceptSchema("agent-identifier");
            aidSchema.add("name", (TermSchema)this.getSchema(STRING));
            aidSchema.add("addresses", (TermSchema)this.getSchema(STRING), 0, -1);
            aidSchema.add("resolvers", aidSchema, 0, -1);
            this.add(aidSchema);
            AgentActionSchema msgSchema = new AgentActionSchema("fipa-acl-message");
            msgSchema.add("sender", (ConceptSchema)this.getSchema("agent-identifier"), 1);
            msgSchema.add("receivers", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            msgSchema.add("reply-to", (ConceptSchema)this.getSchema("agent-identifier"), 0, -1);
            msgSchema.add("language", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("ontology", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("protocol", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("in-reply-to", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("reply-with", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("conversation-id", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("reply-by", (PrimitiveSchema)this.getSchema(DATE), 1);
            msgSchema.add("content", (PrimitiveSchema)this.getSchema(STRING), 1);
            msgSchema.add("bs-content", (PrimitiveSchema)this.getSchema(BYTE_SEQUENCE), 1);
            msgSchema.add("encoding", (PrimitiveSchema)this.getSchema(STRING), 1);
            this.add(msgSchema);
            PredicateSchema truePropSchema = new PredicateSchema("true");
            this.add(truePropSchema);
            PredicateSchema falsePropSchema = new PredicateSchema("false");
            this.add(falsePropSchema);
            AgentActionSchema actionSchema = new AgentActionSchema("action");
            actionSchema.add("actor", (TermSchema)this.getSchema("agent-identifier"));
            actionSchema.add("action", (TermSchema)ConceptSchema.getBaseSchema());
            actionSchema.setEncodingByOrder(true);
            this.add(actionSchema);
            PredicateSchema doneSchema = new PredicateSchema("done");
            doneSchema.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            doneSchema.add("condition", (PredicateSchema)PredicateSchema.getBaseSchema(), 1);
            this.add(doneSchema);
            PredicateSchema resultSchema = new PredicateSchema("result");
            resultSchema.add("action", (AgentActionSchema)AgentActionSchema.getBaseSchema());
            resultSchema.add("value", (TermSchema)TermSchema.getBaseSchema());
            this.add(resultSchema);
            PredicateSchema equalsSchema = new PredicateSchema("=");
            equalsSchema.add("left", TermSchema.getBaseSchema());
            equalsSchema.add("right", TermSchema.getBaseSchema());
            this.add(equalsSchema);
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    public static Ontology getInstance() {
        return theInstance;
    }

    protected Object toObject(AbsObject abs, String lcType, Ontology referenceOnto) throws UngroundedException, OntologyException {
        try {
            if (abs == null) {
                return null;
            }
            if (abs.getAbsType() == 4) {
                return ((AbsPrimitive)abs).getObject();
            }
            if (abs.getAbsType() == 5) {
                return AbsHelper.internaliseList((AbsAggregate)abs, referenceOnto);
            }
            if (abs.getAbsType() == 8) {
                return AbsHelper.internaliseContentElementList((AbsContentElementList)abs, referenceOnto);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "agent-identifier")) {
                return AbsHelper.internaliseAID((AbsConcept)abs);
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "true")) {
                TrueProposition t = new TrueProposition();
                return t;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "false")) {
                FalseProposition t = new FalseProposition();
                return t;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "done")) {
                Done d = new Done();
                d.setAction((AgentAction)referenceOnto.toObject(abs.getAbsObject("action")));
                return d;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "result")) {
                Result r = new Result();
                r.setAction((AgentAction)referenceOnto.toObject(abs.getAbsObject("action")));
                r.setValue(referenceOnto.toObject(abs.getAbsObject("value")));
                return r;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "=")) {
                Equals e = new Equals();
                e.setLeft(referenceOnto.toObject(abs.getAbsObject("left")));
                e.setRight(referenceOnto.toObject(abs.getAbsObject("right")));
                return e;
            }
            if (CaseInsensitiveString.equalsIgnoreCase(abs.getTypeName(), "action")) {
                Action a = new Action();
                a.internalise(abs, referenceOnto);
                return a;
            }
            if (ACLMessage.getInteger(abs.getTypeName()) != -1) {
                return AbsHelper.internaliseACLMessage((AbsAgentAction)abs, referenceOnto);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (Throwable t) {
            throw new OntologyException("Unexpected error internalising " + abs + ".", t);
        }
    }

    protected AbsObject fromObject(Object obj, Ontology referenceOnto) throws OntologyException {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return AbsPrimitive.wrap((String)obj);
            }
            if (obj instanceof Boolean) {
                return AbsPrimitive.wrap((Boolean)obj);
            }
            if (obj instanceof Integer) {
                return AbsPrimitive.wrap((Integer)obj);
            }
            if (obj instanceof Long) {
                return AbsPrimitive.wrap((Long)obj);
            }
            if (obj instanceof Date) {
                return AbsPrimitive.wrap((Date)obj);
            }
            if (obj instanceof byte[]) {
                return AbsPrimitive.wrap((byte[])obj);
            }
            if (obj instanceof List) {
                return AbsHelper.externaliseList((List)obj, referenceOnto, "sequence");
            }
            if (obj instanceof Iterator) {
                return AbsHelper.externaliseIterator((Iterator)obj, referenceOnto, "sequence");
            }
            if (obj instanceof AID) {
                return AbsHelper.externaliseAID((AID)obj);
            }
            if (obj instanceof ContentElementList) {
                return AbsHelper.externaliseContentElementList((ContentElementList)obj, referenceOnto);
            }
            if (obj instanceof TrueProposition) {
                AbsPredicate absTrueProp = new AbsPredicate("true");
                return absTrueProp;
            }
            if (obj instanceof FalseProposition) {
                AbsPredicate absTrueProp = new AbsPredicate("false");
                return absTrueProp;
            }
            if (obj instanceof Done) {
                AbsPredicate absDone = new AbsPredicate("done");
                absDone.set("action", (AbsAgentAction)referenceOnto.fromObject(((Done)obj).getAction()));
                return absDone;
            }
            if (obj instanceof Result) {
                AbsPredicate absResult = new AbsPredicate("result");
                absResult.set("action", (AbsAgentAction)referenceOnto.fromObject(((Result)obj).getAction()));
                absResult.set("value", (AbsTerm)referenceOnto.fromObject(((Result)obj).getValue()));
                return absResult;
            }
            if (obj instanceof Equals) {
                AbsPredicate absEquals = new AbsPredicate("=");
                absEquals.set("left", (AbsTerm)referenceOnto.fromObject(((Equals)obj).getLeft()));
                absEquals.set("right", (AbsTerm)referenceOnto.fromObject(((Equals)obj).getRight()));
                return absEquals;
            }
            if (obj instanceof Action) {
                AbsAgentAction absAction = new AbsAgentAction("action");
                ((Action)obj).externalise(absAction, referenceOnto);
                return absAction;
            }
            if (obj instanceof ACLMessage) {
                return AbsHelper.externaliseACLMessage((ACLMessage)obj, referenceOnto);
            }
            throw new UnknownSchemaException();
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (Throwable t) {
            throw new OntologyException("Unexpected error externalising " + obj + ".", t);
        }
    }

    public ObjectSchema getSchema(String name) throws OntologyException {
        int perf;
        ObjectSchema ret = super.getSchema(name);
        if (ret == null && (perf = ACLMessage.getInteger(name)) != -1) {
            ret = this.createMsgSchema(name);
        }
        return ret;
    }

    private ObjectSchema createMsgSchema(String performative) throws OntologyException {
        AgentActionSchema msgSchema = new AgentActionSchema(performative);
        msgSchema.addSuperSchema((AgentActionSchema)this.getSchema("fipa-acl-message"));
        return msgSchema;
    }

    static {
        theInstance.initialize();
    }
}

